## Today's 05-01-24 [Problem Link](https://leetcode.com/problems/longest-increasing-subsequence/description/?envType=daily-question&envId=2024-01-05)

# Intuition
<!-- Describe your first thoughts on how to solve this problem. -->
- Dynamic Programming
- - My algorithm must use dynamic programming to efficiently update and maintain the longest increasing subsequence.
- Greedy Choice
- - My algorithm must makes a greedy choice to update the current longest increasing subsequence (a) based on the incoming elements from the input array (nums).



# Approach
<!-- Describe your approach to solving the problem. -->
- ArrayList 'a'
- - I used 'a' to store the current longest increasing subsequence.
- - It starts as an empty ArrayList.
- Iterating through nums
- - My code iterates through each element 's' in the input array nums.
- - For each element :
- - - If a is empty or s is greater than the last element in a, add s to a (greedy choice as it contributes to increasing subsequence).
- - - Otherwise, found the correct position for s in a using the bs function, and update the element at that position with s.
- Binary Search Function 'bs':
- - The 'bs' function performs a binary search on the sorted ArrayList 'a' to find the index of 's' or the index where 's' should be inserted.
- - If 's' is found, it returns the index. If not found, it returns the negation of the insertion point. This insertion point is used to update the current increasing subsequence.
- Return Result :
- - Finally, I returned the length of the longest increasing subsequence is the size of the ArrayList a.
---
- If you're still having trouble understanding what the binary search functions does here, I would suggest you to please go through this site  [search here for binarySearch](https://docs.oracle.com/javase%2F7%2Fdocs%2Fapi%2F%2F/java/util/Collections.html)
---
Have a look at the code , still have any confusion then please let me know in the comments
Keep Solving.:)
# Complexity
- Time complexity : $$O(l*log(l))$$
<!-- Add your time complexity here, e.g. $$O(n)$$ -->

- Space complexity : $$O(l)$$
<!-- Add your space complexity here, e.g. $$O(n)$$ -->
$$l$$ : length of array.
# Code
```
class Solution {
    public int lengthOfLIS(int[] nums) {
        
        ArrayList<Integer> a = new ArrayList<>();
        for( int s : nums){
            if( a.isEmpty() || s > a.get( a.size() - 1) ){
                a.add(s);
            } 
            else{
                a.set( bs(a, s) , s);
            }
        }
        return a.size();
    }

    static int bs( ArrayList<Integer> a, int s){
        int in = Collections.binarySearch(a, s);
        if( in < 0){
            return - in - 1;
        }
        return in;
    }
}
```
